define([
    'jquery',
    'mage/utils/wrapper',
    'Asics_Verifone/js/model/checkout-registry'
], function (
    $,
    wrapper,
    checkoutRegistry
) {
    'use strict';

    return function (getPaymentInformationFunction) {
        return wrapper.wrap(getPaymentInformationFunction, function (originalGetPaymentInformationFunction, ...args) {
            if (checkoutRegistry.shouldPreventGetPaymentInformation()) {
                return $.Deferred();
            }

            return originalGetPaymentInformationFunction(...args);
        });
    };
});
