define([
    'jquery',
    'matchMedia',
    'slick',
    'domReady!'
], function ($, mediaCheck) {
    'use strict';

    return function (config, element) {
        var pickedElement = element;
        var pickedViewMore = pickedElement.find('#pickedViewMore');
        var pickedItemsContainer = pickedElement.find('#pickedContainer');
        var pickedItemsNum = pickedItemsContainer.children().length;
        var categoryTilesContainer = $(element).find('#pickedContainer');

        if(pickedItemsNum <= 3){
            pickedElement.addClass('hide-view-more')
        }

        pickedViewMore.on('click', function(){
            pickedElement.addClass('activate-view-more')
        });

        mediaCheck({
            media: '(min-width: 1025px)',
            exit: function() {
                categoryTilesContainer.slick({
                    dots: false,
                    arrows: true,
                    infinite: false,
                    speed: 300,
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    responsive: [
                        {
                            breakpoint: 1025,
                            settings: {
                                slidesToShow: 4,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        }
                    ]
                });
            }
        });
    };
});
