<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace BrittainWynyard\CatalogAttributes\Setup\Patch\Data;

use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;

class AddAsicsModelProductAttribute implements DataPatchInterface, PatchRevertableInterface
{

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;
    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * Constructor
     *
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            'asics_model',
            [
                'type' => 'int',
                'label' => 'Model',
                'input' => 'select',
                'source' => '',
                'frontend' => '',
                'required' => false,
                'backend' => '',
                'sort_order' => '30',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'default' => null,
                'visible' => true,
                'user_defined' => true,
                'searchable' => true,
                'filterable' => true,
                'comparable' => false,
                'visible_on_front' => true,
                'unique' => false,
                'apply_to' => '',
                'group' => 'General',
                'used_in_product_listing' => true,
                'is_used_in_grid' => true,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'option' => array('values' => array("GEL-KAYANO","GT-2000","GT-1000","GEL-NIMBUS","GEL-CUMULUS","GEL-PURSUE","EVORIDE","GLIDERIDE","GEL-PULSE","GEL-CONTEND","GEL-SONOMA","GEL-ODYSSEY","LETHAL WARNO ST2","GEL-ODI","GEL-GULLY","GEL-QUANTUM 90","GEL-QUANTUM 180","350 NOT OUT FF","GEL-QUANTUM 360","GEL-540TR","GT-800","GT-2000 SX","GT-4000","COURT FF","DYNABLAST","FUJITRABUCO LYTE","GEL-LEATHAL TOUCH PRO","GEL-ACE PRO","GEL-ACE TOUR","GEL-BLACKHEATH","GEL-CARDIO ZIP","GEL-DEDICATE","GEL-DS TRAINER","GEL-EXALT","GEL-FUJITRABUCO","GEL-KYRIOS","GEL-LETHAL ELITE","GEL-LETHAL TIGHT FIVE","GEL-LYTE III","GEL-NIMBUS LITE","GEL-NOOSA TRI","GEL-PEAKE","GEL-QUANTUM INFINITY","GEL-RESOLUTION","GEL-RINK SCORCHER","GEL-ROCKET","GEL-SCRAM","GEL-SHEPPARTON","GEL-TARTHEREDGE","GEL-TARTHERZEAL","HYPER SPRINT","HYPER XC","JAPAN S","LETHAL FLASH IT","LETHAL SPEED RS","LETHAL SPEED ST","LETHAL TACKLE","LETHAL TESTIMONIAL","LETHAL TIGREOR IT FF","LYTE CLASSIC","MENACE","METARACER","NOVABLAST","ROADHAWK","SOLUTION SPEED FF","STRIKE RATE FF","ULTREZZA"))
            ]
        );

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    public function revert()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY, 'asics_model');

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [
        
        ];
    }
}

