<?php
namespace BrittainWynyard\GoogleTagManager\Helper;

/**
 * GoogleAnalytics data helper
 *
 * @api
 * @since 100.0.2
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    protected $productRepository;

    /**
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
    )
    {
        $this->productRepository = $productRepository;
        parent::__construct($context);
    }

    public function getProductAttributeValueByCode($id, $code) {
        $product = $this->productRepository->getById($id);
        if (is_object($attribute = $product->getResource()->getAttribute($code))) {
            return $attribute->getFrontend()->getValue($product);
        }
        return '';
    }
}
