<?php

namespace BrittainWynyard\Sales\Plugin;

use Magento\Framework\Exception\CouldNotSaveException;

class OrderSave
{
    private $orderRepository;
    private $searchCriteriaBuilder;

    public function __construct(
        \Magento\Sales\Model\OrderRepository $orderRepository,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder
    ){
        $this->orderRepository = $orderRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    public function afterSave(
        \Magento\Sales\Api\OrderRepositoryInterface $subject,
        \Magento\Sales\Api\Data\OrderInterface $resultOrder
    ) {
        //extension attributes not auto save to db
        //use saveAccredoFetchedAt to update order attribute value
        $resultOrder = $this->saveAccredoFetchedAt($resultOrder);

        return $resultOrder;
    }

    private function saveAccredoFetchedAt(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        $extensionAttributes = $order->getExtensionAttributes();

        if (
            null !== $extensionAttributes &&
            null !== $extensionAttributes->getAccredoFetchedAt()
        ) {
            $accredoFetchedAtValue = $extensionAttributes->getAccredoFetchedAt();

            try {
                //load order by entity_id
                $records = $this->orderRepository->getList(
                    $this->searchCriteriaBuilder
                        ->addFilter('entity_id', $order->getEntityId())
                        ->create()
                );
                $items = $records->getItems();

                $updatedOrder = array_shift($items);
                // save accredo_fetched_at value
                $updatedOrder->setAccredoFetchedAt($accredoFetchedAtValue);
                $this->orderRepository->save($updatedOrder);
            } catch (\Exception $e) {
                throw new CouldNotSaveException(
                    __('Could not add attribute to order: "%1"', $e->getMessage()),
                    $e
                );
            }
        }
        return $order;
    }
}
