<?php

namespace BrittainWynyard\Searchspring\ViewModel;

use Magento\Customer\Model\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Http\Context as HttpContext;
use Magento\Customer\Api\GroupRepositoryInterface;

class ConfigProvider implements ArgumentInterface
{

    const XML_PATH_IS_ENABLED = 'searchspring/searchspring_configuration/enabled';
    const XML_PATH_SITE_ID = 'searchspring/searchspring_configuration/site_id';
    const XML_PATH_CATEGORY_ID = 'searchspring/searchspring_configuration/category_id';

    /**
     * ConfigProvider constructor.
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     * @param HttpContext $httpContext
     */
    public function __construct(
        protected ScopeConfigInterface  $scopeConfig,
        protected StoreManagerInterface $storeManager,
        protected HttpContext           $httpContext,
        protected GroupRepositoryInterface $groupRepository
    )
    {
    }

    public function isEnabled(): ?bool
    {
        try {
            return $this->scopeConfig->getValue(
                self::XML_PATH_IS_ENABLED,
                ScopeInterface::SCOPE_STORE,
                $this->storeManager->getStore()->getId()
            );
        } catch (NoSuchEntityException $e) {
            return false;
        }
    }

    public function getSiteID(): string|false|null
    {
        if (!$this->isEnabled()) {
            return false;
        }
        try {
            return $this->scopeConfig->getValue(
                self::XML_PATH_SITE_ID,
                ScopeInterface::SCOPE_STORE,
                $this->storeManager->getStore()->getId()
            );
        } catch (NoSuchEntityException $e) {
            return false;
        }
    }

    public function getCatalogID(): string|false|null
    {
        if (!$this->isEnabled()) {
            return false;
        }
        try {
            return $this->scopeConfig->getValue(
                self::XML_PATH_CATEGORY_ID,
                ScopeInterface::SCOPE_STORE,
                $this->storeManager->getStore()->getId()
            );
        } catch (NoSuchEntityException $e) {
            return false;
        }
    }

    public function getCurrentCustomerGroupId()
    {
        return $this->httpContext->getValue(Context::CONTEXT_GROUP);
    }

    public function getCustomerGroupName()
    {
        try {
            $groupId = $this->getCurrentCustomerGroupId();
            return $this->groupRepository->getById($groupId)->getCode();
        } catch (NoSuchEntityException $e) {
            return null;
        }
    }
}
