<?php

namespace Overdose\Afterpay\Controller\Express;

use Afterpay\Afterpay\Controller\Express\PlaceOrder;
use Afterpay\Afterpay\Gateway\Config\Config;
use Afterpay\Afterpay\Model\Payment\Capture\PlaceOrderProcessor;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\UrlInterface;
use Magento\Payment\Gateway\CommandInterface;
use Throwable;

class PlaceOrderRewrite extends PlaceOrder
{
    const CANCELLED_STATUS = 'CANCELLED';

    private RequestInterface $request;
    private ManagerInterface $messageManager;
    private Session $checkoutSession;
    private JsonFactory $jsonFactory;
    private UrlInterface $url;
    private PlaceOrderProcessor $placeOrderProcessor;
    private CommandInterface $syncCheckoutDataCommand;

    /**
     * PlaceOrderRewrite constructor.
     * 
     * @param RequestInterface $request
     * @param ManagerInterface $messageManager
     * @param Session $checkoutSession
     * @param JsonFactory $jsonFactory
     * @param UrlInterface $url
     * @param PlaceOrderProcessor $placeOrderProcessor
     * @param CommandInterface $syncCheckoutDataCommand
     */
    public function __construct(
        RequestInterface $request,
        ManagerInterface $messageManager,
        Session $checkoutSession,
        JsonFactory $jsonFactory,
        UrlInterface $url,
        PlaceOrderProcessor $placeOrderProcessor,
        CommandInterface $syncCheckoutDataCommand
    ) {
        parent::__construct(
            $request,
            $messageManager,
            $checkoutSession,
            $jsonFactory,
            $url,
            $placeOrderProcessor,
            $syncCheckoutDataCommand
        );
        $this->request = $request;
        $this->messageManager = $messageManager;
        $this->checkoutSession = $checkoutSession;
        $this->jsonFactory = $jsonFactory;
        $this->url = $url;
        $this->placeOrderProcessor = $placeOrderProcessor;
        $this->syncCheckoutDataCommand = $syncCheckoutDataCommand;
    }
    
    public function execute()
    {
        $jsonResult = $this->jsonFactory->create();
        $quote = $this->checkoutSession->getQuote();

        $afterpayOrderToken = $this->request->getParam('orderToken');
        $status = $this->request->getParam('status');

        if ($status === static::CANCELLED_STATUS) {
            return $jsonResult;
        }

        try {
            $quote->getPayment()
                ->setMethod(Config::CODE)
                ->setAdditionalInformation('afterpay_express', true);
            $this->placeOrderProcessor->execute($quote, $this->syncCheckoutDataCommand, $afterpayOrderToken);
        } catch (Throwable $e) {
            $errorMessage = $e instanceof LocalizedException
                ? $e->getMessage()
                : (string)__('Payment is failed');
            $this->messageManager->addErrorMessage($errorMessage);
            /* Start - Custom codes */
            return $jsonResult->setData(['redirectUrl' => $this->url->getUrl('checkout', ['_fragment' => 'payment'])]);
            /* End - Custom codes */
        }

        return $jsonResult->setData(['redirectUrl' => $this->url->getUrl('checkout/onepage/success')]);
    }
}
