<?php

namespace Overdose\Catalog\Plugin;

use Magento\Catalog\Model\CategoryLinkManagement;
use Overdose\Catalog\Model\RebuildPositionCategory;

class RebuildPositionPlugin
{
    /**
     * @var RebuildPositionCategory
     */
    protected $rebuildPositionCategory;

    public function __construct(
        RebuildPositionCategory $rebuildPositionCategory
    ) {
        $this->rebuildPositionCategory = $rebuildPositionCategory;
    }

    /**
     * @param CategoryLinkManagement $subject
     * @param bool $result
     * @param string $productSku
     * @param int[] $categoryIds
     * @return bool
     */
    public function afterAssignProductToCategories(CategoryLinkManagement $subject, bool $result, $productSku, array $categoryIds): bool
    {
        if ($categoryIds) {
            foreach ($categoryIds as $id) {
                $this->rebuildPositionCategory->rebuildPositionByCategoryId($id);
            }
        }
        return $result;
    }
}
