<?php

namespace Overdose\CatalogAttribute\Setup\Patch\Data;

use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class DeleteDuplicates implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * DeleteDuplicates constructor.
     *
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->moduleDataSetup->startSetup();

        $connection = $this->moduleDataSetup->getConnection();

        $this->deleteDuplicatesByTable($connection, 'catalog_product_entity_varchar');
        $this->deleteDuplicatesByTable($connection, 'catalog_product_entity_int');
        $this->deleteDuplicatesByTable($connection, 'catalog_product_entity_datetime');
        $this->deleteDuplicatesByTable($connection, 'catalog_product_entity_decimal');
        $this->deleteDuplicatesByTable($connection, 'catalog_product_entity_text');

        $this->moduleDataSetup->endSetup();
    }

    /**
     * Delete duplicate values from a specific table.
     *
     * @param \Magento\Framework\DB\Adapter\AdapterInterface $connection
     * @param string $tableName
     */
    private function deleteDuplicatesByTable($connection, $tableName)
    {
        $select = $connection->select()
            ->from(
                ['t1' => $this->moduleDataSetup->getTable($tableName)],
                []
            )
            ->joinInner(
                ['t2' => $this->moduleDataSetup->getTable($tableName)],
                't1.attribute_id = t2.attribute_id
                AND t1.store_id = t2.store_id
                AND t1.row_id = t2.row_id
                AND t1.value_id < t2.value_id',
                []
            );

        $deleteSql = $select->deleteFromSelect('t1');
        $connection->query($deleteSql);
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
