<?php

namespace Overdose\CatalogSortToolbar\Cron;

class SortOrderNew
{
    const CLEARANCE_PRODUCT_ATTRIBUTE_ID = 'product_badge';

    protected $optionId;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    protected $productCollectionFactory;

    /**
     * @var \Magento\Catalog\Model\CategoryRepository
     */
    protected $categoryRepository;
    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\Action
     */
    private $action;
    /**
     * @var \Magento\Eav\Model\Config
     */
    private $eavConfig;

    /**
     * SortOrderNew constructor.
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory
     * @param \Magento\Catalog\Model\CategoryRepository $categoryRepository
     */
    public function __construct(
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\CategoryRepository $categoryRepository,
        \Magento\Catalog\Model\ResourceModel\Product\Action $action,
        \Magento\Eav\Model\Config $eavConfig
    ) {
        $this->productCollectionFactory = $productCollectionFactory;
        $this->categoryRepository = $categoryRepository;
        $this->action = $action;
        $this->eavConfig = $eavConfig;
    }

    public function execute()
    {
        $sortOrder = 1;

        foreach ($this->getProductCollection() as $product) {
            $this->saveProductAttribute($product->getId(), $sortOrder++);
        }

        foreach ($this->getProductCollection(true) as $clearanceProduct) {
            $this->saveProductAttribute($clearanceProduct->getId(), $sortOrder++);
        }
    }

    public function saveProductAttribute($productId, $value, $storeId = 0)
    {
        $this->action->updateAttributes([$productId], ['sort_order_new' => $value], $storeId);
    }

    protected function getProductCollection($withClearance = false)
    {
        $collection = $this->productCollectionFactory->create();
        $collection->addAttributeToSelect(['sort_order_new', self::CLEARANCE_PRODUCT_ATTRIBUTE_ID])
            ->setOrder('created_at', 'desc');

        if ($this->optionId === null) {
            $attribute = $this->eavConfig->getAttribute('catalog_product', self::CLEARANCE_PRODUCT_ATTRIBUTE_ID);
            $options = $attribute->getSource()->getAllOptions();

            foreach ($options as $option) {
                if ($option['label'] == 'Clearance') {
                    $this->optionId = $option['value'];
                }
            }
        }

        if ($this->optionId) {
            if ($withClearance) {
                $collection->addFieldToFilter(self::CLEARANCE_PRODUCT_ATTRIBUTE_ID, $this->optionId);
            } else {
                $collection->addFieldToFilter(self::CLEARANCE_PRODUCT_ATTRIBUTE_ID, ['neq' => $this->optionId]);
            }
        }

        return $collection->load();
    }
}
