<?php

namespace Overdose\DataLayer\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Stdlib\Cookie\CookieSizeLimitReachedException;
use Magento\Framework\Stdlib\Cookie\FailureToSendException;
use Overdose\DataLayer\Helper\Cookies;
use Magento\Framework\App\RequestInterface;

/**
 * Class SubscribeToNewsletter
 * @package Overdose\DataLayer\Observer
 */
class SubscribeToNewsletter implements ObserverInterface
{
    /**#@+
     * Constructor params
     */
    protected Cookies $cookiesHelper;
    protected RequestInterface $request;
    /**#@-*/

    /**
     * @var string
     */
    protected string $identification_location = 'newsletter_subscription';

    /**
     * SubscribeToNewsletter constructor.
     * @param Cookies $cookiesHelper
     * @param RequestInterface $request
     */
    public function __construct(
        Cookies $cookiesHelper,
        RequestInterface $request
    ) {
        $this->cookiesHelper = $cookiesHelper;
        $this->request = $request;
    }

    /**
     * Even location on the site
     *
     * @var array|string[]
     */
    protected array $placement = [
        'footer', 'popup_outOfStock', 'popup_login',
        'customer_account', 'checkout_successpage'
    ];

    /**
     * Statuses about subscription
     *
     * @var array|string[]
     */
    protected array $status = ['is_subscribed', 'recive_promotion'];

    /**
     * Form data and attach to cookie
     *
     * @param Observer $observer
     * @throws InputException
     * @throws CookieSizeLimitReachedException
     * @throws FailureToSendException
     */
    public function execute(Observer $observer)
    {
        $event = 'newsletter_sign_up';
        $placementAndStatus = array_merge($this->placement, $this->status);
        $currentPlacementAndStatus = array_intersect(array_keys($this->request->getParams()), $placementAndStatus);

        if (count($currentPlacementAndStatus) == 2 || $this->request->getParam('footer')) {
            $this->buildIdentifierLocation(array_intersect($this->placement, $currentPlacementAndStatus));
        }

        $this->cookiesHelper->setDataLayerCookieUserIdentify($observer->getSubscriber()->getSubscriberEmail());
        $this->cookiesHelper->setDataLayerCookie($event, $this->identification_location);
    }

    /**
     * Build location identifier
     *
     * @param $placement array
     */
    protected function buildIdentifierLocation(array $placement)
    {
        $this->identification_location = $this->identification_location . '_' . array_shift($placement);
    }
}
