<?php

namespace Overdose\DataLayer\Plugin\Anowave\Ec\Helper;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;
use Magento\Framework\Stdlib\CookieManagerInterface;
use Overdose\DataLayer\Helper\Ec as OverdoseHelper;

class Data
{
    protected $productRepository;

    /**
     * @var CategoryRepositoryInterface
     */
    protected $categoryRepository;

    /** @var CategoryCollectionFactory */
    protected $categoryCollectionFactory;

    /**
     * @var OverdoseHelper
     */
    protected $overdoseHelper;

    /**
     * @var CookieManagerInterface
     */
    protected CookieManagerInterface $cookieManager;

    /**
     * @param ProductRepository $productRepository
     * @param CategoryRepositoryInterface $categoryRepository
     * @param CategoryCollectionFactory $categoryCollectionFactory
     * @param CookieManagerInterface $cookieManager
     * @param OverdoseHelper $overdoseHelper
     */
    public function __construct(
        ProductRepository           $productRepository,
        CategoryRepositoryInterface $categoryRepository,
        CategoryCollectionFactory   $categoryCollectionFactory,
        CookieManagerInterface      $cookieManager,
        OverdoseHelper              $overdoseHelper
    ) {
        $this->productRepository = $productRepository;
        $this->categoryRepository = $categoryRepository;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->cookieManager = $cookieManager;
        $this->overdoseHelper = $overdoseHelper;
    }

    public function afterGetDetailPushForward($subject, $result, $block)
    {
        if ($result && $result->payload) {
            $payload = json_decode($result->payload, true);
            if (isset($payload['ecommerce']) && $payload['ecommerce']) {
                switch ($payload['event']) {
                    case 'view_item':
                        $info = $block->getLayout()->getBlock('product.info');
                        $productClickData = $this->cookieManager->getCookie('od-product-click');
                        if ($info && $info->getProduct()) {
                            $product = $info->getProduct();
                            $customData = [];
                            $ecommerceData = $payload['ecommerce'];
                            $customData['currency'] = $ecommerceData['currency'];
                            $customData['value'] = (float)$ecommerceData['value'];
                            $itemData = [];
                            if (isset($payload['ecommerce']['items'][0])) {
                                $itemData['item_id'] = $ecommerceData['items'][0]['item_id'];
                                $itemData['item_name'] = $ecommerceData['items'][0]['item_name'];
                                $itemData['index'] = $this->overdoseHelper->getProductIndex($productClickData, $itemData['item_id'], $product->getId());
                                $itemData['affiliation'] = $subject->getBrand($product);
                                $discount = $this->checkSpecialPriceProduct($product);
                                if ($discount) {
                                    $itemData['discount'] = $discount;
                                }
                                $itemData['item_brand'] = $subject->getBrand($product);;
                                $mainCategoryId = $product->getMainCategory();
                                if ($mainCategoryId) {
                                    $mainCategory = $this->categoryRepository->get($mainCategoryId);
                                    $catCollection = $this->categoryCollectionFactory->create()
                                        ->addAttributeToSelect(['name', 'url'])
                                        ->addAttributeToFilter('entity_id', ['in' => $mainCategory->getPathIds()]);
                                    foreach ($catCollection as $catItem) {
                                        if ($catItem->getLevel() > 1) {
                                            if (!isset($itemData['item_category'])) {
                                                $itemData['item_category'] = $catItem->getName();
                                            } elseif (!isset($itemData['item_category2'])) {
                                                $itemData['item_category2'] = $catItem->getName();
                                            } elseif (!isset($itemData['item_category3'])) {
                                                $itemData['item_category3'] = $catItem->getName();
                                            } elseif (!isset($itemData['item_category4'])) {
                                                $itemData['item_category4'] = $catItem->getName();
                                            }
                                        }
                                    }
                                }
                                $itemData['item_list_id'] = $this->overdoseHelper->getItemListId($productClickData, $product);
                                $itemData['item_list_name'] = $this->overdoseHelper->getItemListname($productClickData, $product);
                                $itemData['price'] = $payload['ecommerce']['items'][0]['price'];
                                $marketingColour = $product->getResource()->getAttribute('mkt_colour')->getFrontend()->getValue($product);
                                if (!$marketingColour) {
                                    $marketingColour = $product->getName();
                                }
                                $itemData['item_variant'] = $marketingColour;
                                $width = $product->getResource()->getAttribute('width')->getFrontend()->getValue($product);
                                if ($width) {
                                    $itemData['item_width'] = $width;
                                }
                                $itemData['item_size'] = '';
                                $itemData['quantity'] = 1;
                            }

                            $customData['items'][] = $itemData;
                            $payload['ecommerce'] = $customData;
                            $result->payload = json_encode($payload);
                        }
                        break;
                    default:
                }
            }
        }
        return $result;
    }

    /**
     * @param $product
     * @return int|mixed
     */
    public function checkSpecialPriceProduct($product)
    {
        if ($product->getTypeId() == 'bundle') {
            $finalPrice = $product->getPriceInfo()->getPrice('final_price')->getMinimalPrice()->getValue();
            $orgPrice = $product->getPriceInfo()->getPrice('regular_price')->getMinimalPrice()->getValue();
        } elseif ($product->getTypeId() == 'grouped') {
            $usedProds = $product->getTypeInstance(true)->getAssociatedProducts($product);
            $finalPrice = 0;
            $orgPrice = 0;
            foreach ($usedProds as $child) {
                if ($child->getId() != $product->getId()) {
                    $finalPrice += $child->getFinalPrice();
                    $orgPrice += $child->getPrice();
                }
            }
        } elseif ($product->getTypeId() == 'configurable') {
            $finalPrice = $product->getPriceInfo()->getPrice('final_price')->getMinimalPrice()->getValue();
            $orgPrice = $product->getPriceInfo()->getPrice('regular_price')->getAmount()->getValue();
        } else {
            $finalPrice = $product->getFinalPrice();
            $orgPrice = $product->getPrice();
        }
        if ($finalPrice && $orgPrice && $finalPrice < $orgPrice) {
            return $orgPrice - $finalPrice;
        }
        return 0;
    }
}
