<?php

namespace Overdose\DataLayer\Plugin\Anowave\Ec;

use Magento\Checkout\Model\Session;
use Magento\Framework\App\Response\Http;
use Overdose\DataLayer\Helper\Ec;
use Magento\Checkout\Model\Cart;
use Anowave\Ec\Helper\Data;
use Magento\Catalog\Model\ProductRepository;
use Magento\Catalog\Model\CategoryRepository;
use Magento\Framework\App\RequestInterface;
use Magento\Customer\Model\Session as CustomerSession;

class Sidebar
{
    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $cart = null;

    /**
     * @var \Anowave\Ec\Helper\Data
     */
    protected $dataHelper = null;

    /**
     * @var \Magento\Catalog\Model\ProductRepository
     */
    protected $productRepository;

    /**
     * @var \Magento\Catalog\Model\CategoryRepository
     */
    protected $categoryRepository;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    protected $request;

    /**
     * Remove flag
     *
     * @var boolean
     */
    private $remove = false;

    /**
     * Update flag
     *
     * @var string
     */
    private $update = false;

    /**
     * @var Ec
     */
    protected $ec;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * @var CustomerSession
     */
    protected $customerSession;


    /**
     * @param Cart $cart
     * @param Data $dataHelper
     * @param ProductRepository $productRepository
     * @param CategoryRepository $categoryRepository
     * @param RequestInterface $request
     * @param Ec $ec
     * @param Session $checkoutSession
     * @param CustomerSession $customerSession
     */
    public function __construct
    (
        Cart               $cart,
        Data               $dataHelper,
        ProductRepository  $productRepository,
        CategoryRepository $categoryRepository,
        RequestInterface   $request,
        Ec                 $ec,
        Session            $checkoutSession,
        CustomerSession    $customerSession
    ) {
        //Custom
        $this->ec = $ec;
        $this->checkoutSession = $checkoutSession;
        $this->customerSession = $customerSession;
        //End Custom

        $this->cart = $cart;

        /**
         * Set helper
         *
         * @var \Anowave\Ec\Helper\Data $dataHelper
         */
        $this->dataHelper = $dataHelper;

        /**
         * Set product repository
         *
         * @var \Magento\Catalog\Model\ProductRepository $productRepository
         */
        $this->productRepository = $productRepository;

        /**
         * Set category repository
         *
         * @var \Magento\Catalog\Model\CategoryRepository $categoryRepository
         */
        $this->categoryRepository = $categoryRepository;

        /**
         * Set request
         *
         * @var \Magento\Framework\App\RequestInterface $request
         */
        $this->request = $request;
    }

    /**
     * After remove item
     *
     * @param \Magento\Checkout\Model\Sidebar $sidebar
     * @param \Magento\Checkout\Model\Sidebar $response
     * @return \Magento\Checkout\Model\Sidebar
     */
    public function afterRemoveQuoteItem(\Magento\Checkout\Model\Sidebar $sidebar, $response)
    {
        /**
         * Set remove
         *
         * @var \Anowave\Ec\Plugin\Sidebar $remove
         */
        $this->remove = true;

        /**
         * Unset update
         *
         * @var \Anowave\Ec\Plugin\Sidebar $update
         */
        $this->update = false;

        return $response;
    }

    /**
     * After update item
     *
     * @param \Magento\Checkout\Model\Sidebar $sidebar
     * @param \Magento\Checkout\Model\Sidebar $response
     * @return \Magento\Checkout\Model\Sidebar
     */
    public function afterUpdateQuoteItem(\Magento\Checkout\Model\Sidebar $sidebar, $response)
    {
        /**
         * Unset remove
         *
         * @var \Anowave\Ec\Plugin\Sidebar $remove
         */
        $this->remove = false;

        /**
         * Set update
         *
         * @var \Anowave\Ec\Plugin\Sidebar $update
         */
        $this->update = true;

        return $response;
    }

    /**
     * Get response data
     *
     * @param \Magento\Checkout\Model\Sidebar $sidebar
     * @param unknown $response
     * @return unknown
     */
    public function afterGetResponseData(\Magento\Checkout\Model\Sidebar $sidebar, $response)
    {
        if ($this->remove) {
            $item = $this->cart->getQuote()->getItemById((int)$this->request->getParam('item_id'));

            if ($item instanceof \Magento\Quote\Api\Data\CartItemInterface) {
                /**
                 * Load product
                 *
                 * @var \Magento\Catalog\Api\Data\ProductInterface $product
                 */
                $product = $this->productRepository->getById
                (
                    $item->getProductId()
                );

                //custom
                $coupon = null;
                try {
                    $quote = $this->checkoutSession->getQuote();
                    if ($quote && $quote->getCouponCode()) {
                        $coupon = $quote->getCouponCode();
                    }
                } catch (\Exception $exception) {

                }

                $discount = 0;
                $itemSku = $item->getSku();
                if ($item->getDiscountAmount()) {
                    $discount = (float)$item->getDiscountAmount();
                }
                $item =
                    [
                        'item_id' => ($this->dataHelper->useSimples() ? $this->dataHelper->getIdentifierItem($item) : $this->dataHelper->getIdentifier($product)),
                        'item_name' => $item->getName(),
                        'quantity' => (float)$item->getQty(),
                        'price' => (float)$item->getPriceInclTax(),
                    ];
                if ($coupon) {
                    $item['coupon'] = $coupon;
                }

                if ($discount) {
                    $item['discount'] = $discount;
                }

                $categoryData = $this->ec->getCategoryData($product);
                $productWidth = $this->ec->getProductWidth($product);
                $productColor = $this->ec->getProductColor($product);
                $variantProduct = $this->ec->getProductBySku($itemSku);
                $size = $this->ec->getSize($variantProduct);
                if ($size) {
                    $item['item_size'] = $size;
                }
                $affiliation = $this->ec->getAffiliation($product);
                $item['affiliation'] = $affiliation;
                $item['item_brand'] = $affiliation;
                $item['item_variant'] = $productColor;
                if ($productWidth) {
                    $item['item_width'] = $productWidth;
                }
                $item = array_merge($item, $categoryData);
                $value = (float)$item['price'] * (float)$item['quantity'];
                if (isset($item['discount'])) {
                    $value = $value - (float)($item['discount']);
                }

                $data =
                    [
                        'event' => \Anowave\Ec\Helper\Constants::EVENT_REMOVE_FROM_CART,
                        'ecommerce' =>
                            [
                                'currency' => $this->dataHelper->getCurrency(),
                                'value' => (float)$value,
                            ]
                    ];

                $odAddToCartSession = $this->customerSession->getOdAddToCartSession();
                $item['item_list_id'] = $this->ec->getSessionItemListId($odAddToCartSession, $product);
                $item['item_list_name'] = $this->ec->getSessionItemListName($odAddToCartSession, $product);

                //End Custom

                /**
                 * Update items
                 */
                $data['ecommerce']['items'] =
                    [
                        $item
                    ];

                $response['remove'] = true;

                /**
                 * Set response push
                 */
                $response['dataLayer'] = $data;
            }

            $this->remove = false;
        }

        if ($this->update) {
            $response['update'] = true;

            $this->update = false;
        }

        return $response;
    }
}
