<?php

namespace Overdose\DataLayer\Plugin;

use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Customer\Model\AccountManagement;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Stdlib\Cookie\CookieSizeLimitReachedException;
use Magento\Framework\Stdlib\Cookie\FailureToSendException;

/**
 * Class CustomerLogin
 * @package Overdose\DataLayer\Plugin
 */
class CustomerLogin extends GenericPlugin
{
    /**
     * @param AccountManagement $subject
     * @param CustomerInterface $result
     * @return CustomerInterface
     * @throws CookieSizeLimitReachedException
     * @throws FailureToSendException
     * @throws InputException
     */
    public function afterAuthenticate(AccountManagement $subject, CustomerInterface $result): CustomerInterface
    {
        $customerEmail = '';
        $event = 'account_login';
        $identification_location = 'login_site';

        if ($result->getEmail()) {
            $customerEmail = strtolower($result->getEmail());
        }

        if (str_contains($this->redirect->getRefererUrl(), self::EMAIL_CHECK_URL_KEY) && !str_contains($this->redirect->getRefererUrl(), self::SUCCESSPAGE_KEY)) {
            $identification_location = 'login_checkout';
        }

        $this->cookiesHelper->setDataLayerCookieUserIdentify($customerEmail);
        $this->cookiesHelper->setDataLayerCookie($event, $identification_location);

        return $result;
    }

    public function afterCreateAccount(AccountManagement $subject, CustomerInterface $result): CustomerInterface
    {
        $customerEmail = '';
        $event = 'account_creation';
        $identification_location = 'account_creation_site';
        if (str_contains($this->redirect->getRefererUrl(), self::SUCCESSPAGE_KEY)) {
            $identification_location = 'account_creation_successpage';
        }

        if ($result->getEmail()) {
            $customerEmail = strtolower($result->getEmail());
        }

        $this->cookiesHelper->setDataLayerCookieUserIdentify($customerEmail);
        $this->cookiesHelper->setDataLayerCookie($event, $identification_location);
        return $result;
    }
}
