define([
    'jquery',
    'uiComponent',
    'ko',
    'uiRegistry',
    'Magento_Ui/js/modal/modal',
    'domReady',
    'matchMedia'
], function ($, Component, ko, registry, modal, domReady, mediaCheck) {
    'use strict';

    return Component.extend({
        defaults: {
            colorOption: ko.observable(''),
            stockList: ko.observable(''),
            msiSourceStockList: ko.observable(''),
            selectedColor: ko.observable(''),
            msiStoreSize: ko.observable(''),
            colourAttr: ko.observable(''),
            msiStock: ko.observable(''),
            msiList: ko.observable(''),
            initMsiStoreSize: ko.observable(''),
            popupModelContent: ko.observable(''),
            isDataLoaded: ko.observable(false),
            isLoading: ko.observable(false)
        },

        initialize: function () {
            this._super();
            
            // Initialize observables if they're not already initialized
            if (!this.selectedColor || typeof this.selectedColor !== 'function') {
                this.selectedColor = ko.observable('');
            }
            if (!this.colorOption || typeof this.colorOption !== 'function') {
                this.colorOption = ko.observable('');
            }
            if (!this.stockList || typeof this.stockList !== 'function') {
                this.stockList = ko.observable('');
            }
            if (!this.msiStoreSize || typeof this.msiStoreSize !== 'function') {
                this.msiStoreSize = ko.observable('');
            }
            if (!this.msiList || typeof this.msiList !== 'function') {
                this.msiList = ko.observable('');
            }
            if (!this.colourAttr || typeof this.colourAttr !== 'function') {
                this.colourAttr = ko.observable('');
            }
            if (!this.msiStock || typeof this.msiStock !== 'function') {
                this.msiStock = ko.observable('');
            }
            if (!this.initMsiStoreSize || typeof this.initMsiStoreSize !== 'function') {
                this.initMsiStoreSize = ko.observable('');
            }
            if (!this.popupModelContent || typeof this.popupModelContent !== 'function') {
                this.popupModelContent = ko.observable('');
            }
            if (!this.isDataLoaded || typeof this.isDataLoaded !== 'function') {
                this.isDataLoaded = ko.observable(false);
            }
            if (!this.isLoading || typeof this.isLoading !== 'function') {
                this.isLoading = ko.observable(false);
            }
            
            var self = this;
        },

        handleStockCheckClick: function() {
            // Prevent multiple rapid clicks
            if (this.isLoading && this.isLoading()) {
                return;
            }
            
            if (!this.isDataLoaded()) {
                this.loadStockData();
            } else {
                this.openModal();
            }
        },


        loadStockData: function () {
            var self = this;
            self.isLoading(true);
            self.updateButtonState(true);

            $.ajax({
                url: self.ajaxUrl,
                type: 'GET',
                data: {
                    product_id: self.productId
                },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        // Data is already decoded as objects from the AJAX response
                        self.colourAttr(response.data.colourAttr || []);
                        self.msiStock(response.data.msiStock || []);
                        self.msiList(response.data.msiList || {});
                        self.initMsiStoreSize(response.data.initMsiStoreSize || []);
                        self.popupModelContent(response.data.popupModelContent || '');
                        self.iniOutputData();
                        self.isDataLoaded(true);
                        self.openModal();
                    } else {
                        alert('Failed to load inventory data.');
                    }
                },
                error: function (xhr, status, error) {
                    alert('Failed to load inventory data.');
                },
                complete: function () {
                    self.isLoading(false);
                    self.updateButtonState(false);
                }
            });
        },

        openModal: function () {
            var self = this;
            var options = {
                type: 'popup',
                responsive: true,
                innerScroll: true,
                modalClass: 'stock-availability-modal',
                title: '',
                buttons: []
            };
            
            $("#stock-modal-content").modal(options).modal('openModal');
            
            // Only call onColorChange if data is loaded
            if (self.isDataLoaded()) {
                // Longer delay to ensure the modal and select element are fully rendered
                setTimeout(function() {
                    self.onColorChange();
                }, 200);
            }
        },

        updateButtonState: function (loading) {
            if (loading) {
                $('.btn-text').hide();
                $('.btn-loading').show();
                $('#check-store-stock-btn').prop('disabled', true);
            } else {
                $('.btn-text').show();
                $('.btn-loading').hide();
                $('#check-store-stock-btn').prop('disabled', false);
            }
        },

        iniOutputData: function () {
            var self = this;
            
            // Set the color options first
            if (typeof self.colorOption === 'function') {
                self.colorOption(self.colourAttr());
            }
            
            // Find the current product color from the color attributes
            var currentColorPid = null;
            var colorOptions = self.colourAttr();
            
            if (colorOptions && Array.isArray(colorOptions)) {
                for (var i = 0; i < colorOptions.length; i++) {
                    if (colorOptions[i].is_current === true) {
                        currentColorPid = colorOptions[i].pid;
                        break;
                    }
                }
            }
            
            // Set the current product color as default selection AFTER setting color options
            if (typeof self.selectedColor === 'function') {
                var selectedPid = currentColorPid || self.productId;
                // Use setTimeout to ensure the color options are rendered first
                setTimeout(function() {
                    self.selectedColor(selectedPid);
                    // Force update the select element
                    self.updateSelectElement(selectedPid);
                }, 50);
            }
            
            if (typeof self.stockList === 'function') {
                self.stockList(self.msiStock());
            }
            if (typeof self.msiStoreSize === 'function') {
                self.msiStoreSize(self.initMsiStoreSize());
            }
        },

        updateSelectElement: function(selectedPid) {
            var self = this;
            // Find the select element and manually set its value
            var selectElement = $('.od-availability-color-option');
            if (selectElement.length > 0) {
                selectElement.val(selectedPid);
                // Trigger change event to update KnockoutJS
                selectElement.trigger('change');
            }
        },

        isMobileCheck() {
            var check;
            mediaCheck({
                media: '(min-width: 768px)',
                entry: function () {
                    check = false;
                },
                exit: function () {
                    check = true;
                }
            });
            return check;
        },

        onColorChange: function () {
            // Ensure observables are functions before calling them
            if (typeof this.msiList !== 'function' || typeof this.selectedColor !== 'function') {
                return;
            }
            
            var msiListData = this.msiList();
            var pid = this.selectedColor();
            
            if (msiListData && msiListData[pid]) {
                for (var index = 0; index < msiListData[pid].length; index++) {
                    if (typeof this.msiStoreSize === 'function') {
                        this.msiStoreSize(msiListData[pid][index]['msi_lists'][index]['store_size']);
                    }
                    if (typeof this.stockList === 'function') {
                        this.stockList(msiListData[pid][index]['msi_lists']);
                    }
                    break;
                }
            }
        },
    });
});
