<?php
namespace Overdose\LazyLoadJavascript\View\Page\Config;

use Magento\Framework\App\Request\Http;
use Magento\Framework\Escaper;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Stdlib\StringUtils;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Asset\GroupedCollection;
use Magento\Framework\View\Asset\MergeService;
use Magento\Framework\View\DesignInterface;
use Magento\Framework\View\Page\Config;
use Magento\Framework\View\Page\Config\RendererInterface;
use Psr\Log\LoggerInterface;

/**
 * Page config Renderer model
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class Renderer extends Config\Renderer implements RendererInterface
{

    /**
     * @var Http
     */
    protected  $request;

    /**
     * @var DesignInterface
     */
    protected  $design;


    /**
     * @param Config $pageConfig
     * @param MergeService $assetMergeService
     * @param UrlInterface $urlBuilder
     * @param Escaper $escaper
     * @param StringUtils $string
     * @param LoggerInterface $logger
     * @param DesignInterface $design
     * @param Http $request
     */
    public function __construct(
        Config $pageConfig,
        MergeService $assetMergeService,
        UrlInterface $urlBuilder,
        Escaper $escaper,
        StringUtils $string,
        LoggerInterface $logger,
        DesignInterface $design,
        Http $request

    ) {
        $this->request = $request;
        $this->design = $design;
        parent::__construct($pageConfig,$assetMergeService,$urlBuilder,$escaper,$string,$logger);

    }

    /**
     * Render HTML tags referencing corresponding URLs
     *
     * @param \Magento\Framework\View\Asset\PropertyGroup $group
     * @return string
     */
    protected function renderAssetHtml(\Magento\Framework\View\Asset\PropertyGroup $group): string
    {
        $assets = $this->processMerge($group->getAll(), $group);
        $attributes = $this->getGroupAttributes($group);
        $fullActionName = $this->request->getFullActionName();
        $result = '';
        try {
            /** @var $asset \Magento\Framework\View\Asset\AssetInterface */
            foreach ($assets as $asset) {
                $assetUrl = $asset->getUrl();
                $template = $this->getAssetTemplate(
                    $group->getProperty(GroupedCollection::PROPERTY_CONTENT_TYPE),
                    $this->addDefaultAttributes($this->getAssetContentType($asset), $attributes)
                );
                if(method_exists($asset,'getContext') &&
                    $asset->getContext()->getPath() == "_cache/merged" &&
                    $asset->getContentType() == "js" &&
                    ($fullActionName == "cms_index_index" ||
                        $fullActionName == "catalog_category_view" ||
                        $fullActionName == "catalog_product_view")
                ){
                    $result .= "<script> window.merged_js_url = '".$assetUrl."';</script>";
                }
                else{
                    $result .= sprintf($template, $assetUrl);
                }
            }
        } catch (LocalizedException $e) {
            $this->logger->critical($e);
            $result .= sprintf($template, $this->urlBuilder->getUrl('', ['_direct' => 'core/index/notFound']));
        }
        return $result;
    }
}
