<?php

namespace Overdose\ProductBanners\Ui\DataProvider\Product\Form\Modifier;

use Magento\Catalog\Model\Locator\LocatorInterface;
use Magento\Eav\Model\Entity\Attribute\Set;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory;
use Overdose\ProductBanners\Model\Product\Type\Banner;
use Overdose\ProductBanners\Setup\Patch\Data\AddBannerProductsAttributes;

class BannerAttributeSet extends \Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\AbstractModifier
{
    /**
     * Set collection factory
     *
     * @var CollectionFactory
     */
    protected $attributeSetCollectionFactory;

    /**
     * @var LocatorInterface
     */
    protected $locator;

    /**
     * @var \Magento\Eav\Model\Entity\Attribute\SetFactory
     */
    protected $setFactory;

    /**
     * @param LocatorInterface $locator
     * @param CollectionFactory $attributeSetCollectionFactory
     * @param \Magento\Eav\Model\Entity\Attribute\SetFactory $setFactory
     */
    public function __construct(
        LocatorInterface $locator,
        CollectionFactory $attributeSetCollectionFactory,
        \Magento\Eav\Model\Entity\Attribute\SetFactory $setFactory
    ) {
        $this->locator = $locator;
        $this->attributeSetCollectionFactory = $attributeSetCollectionFactory;
        $this->setFactory = $setFactory;
    }

    /**
     * Return attribute set id by name of attribute set
     *
     * @return int|null
     */
    public function getBannerAttributeSetId()
    {
        $attributeSet = $this->setFactory->create()
            ->load(
                AddBannerProductsAttributes::BANNER_ATTRIBUTE_SET,
                Set::KEY_ATTRIBUTE_SET_NAME
            );

        if ($attributeSet) {
            return $attributeSet->getAttributeSetId();
        }

        return null;
    }

    /**
     * @inheritdoc
     */
    public function modifyMeta(array $meta)
    {
        return $meta;
    }

    /**
     * @inheritdoc
     */
    public function modifyData(array $data)
    {
        $product = $this->locator->getProduct();

        if ($product->getId() === null && $product->getTypeId() === Banner::PRODUCT_TYPE_BANNER) {
            return array_replace_recursive(
                $data,
                [
                    $this->locator->getProduct()->getId() => [
                        self::DATA_SOURCE_DEFAULT => [
                            'attribute_set_id' => $this->getBannerAttributeSetId(),
                        ],
                    ],
                ]
            );
        } else {
            return $data;
        }
    }
}
