<?php

namespace Overdose\SnowdogMenu\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\Framework\View\Design\Theme\ThemeProviderInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    const KEY_OVERDOSE_NAVIGATION_THEME_ID = 'design/theme/theme_id';
    const MOBILE_MENU_IDENTIFIER = 'overdose_menu/mobile/menu_identifier';
    const MOBILE_MENU_CLEAR_CACHE = 'overdose_menu/mobile/clear_cache_menu';

    /** @var StoreManagerInterface */
    protected $storeManager;

    /** @var ThemeProviderInterface */
    protected $themeProvider;

    protected $menuFilePath;

    /**
     * Data constructor.
     * @param Context $context
     * @param StoreManagerInterface $storeManager
     * @param ThemeProviderInterface $themeProvider
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        ThemeProviderInterface $themeProvider
    ) {
        parent::__construct($context);
        $this->storeManager = $storeManager;
        $this->themeProvider = $themeProvider;
    }
    /**
     * @return string
     */
    public function getTheme()
    {
        $id = $this->scopeConfig->getValue(self::KEY_OVERDOSE_NAVIGATION_THEME_ID);
        $theme = $this->themeProvider->getThemeById($id);
        return $theme->getFullPath();
    }

    /**
     * @return mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getLanguage()
    {
        $id = $this->storeManager->getStore()->getId();
        return $this->scopeConfig->getValue(
            \Magento\Directory\Helper\Data::XML_PATH_DEFAULT_LOCALE,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $id
        );
    }

    /**
     * @return string
     */
    public function getPathWriteMenuInPub()
    {
        if (!$this->menuFilePath) {
            $this->menuFilePath = '/' . \Magento\Framework\View\Design\Theme\Customization\Path::DIR_NAME . '/' .
                $this->getTheme() . '/' . $this->getLanguage() . '/Overdose_SnowdogMenu/menu';
            }
        return $this->menuFilePath;
    }

    /**
     * @return mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getMobileMenuIdentifier()
    {
        return $this->scopeConfig->getValue(
            self::MOBILE_MENU_IDENTIFIER,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return mixed
     */
    public function getClearCacheMenu()
    {
        return $this->scopeConfig->getValue(
            self::MOBILE_MENU_CLEAR_CACHE
        );
    }

}
