define([
    'Magento_Ui/js/grid/columns/column',
    'Magento_Catalog/js/product/list/column-status-validator'
], function (Column, columnStatusValidator) {
    'use strict';

    return Column.extend({
        hasValue: function(row) {
            if(this.getValue(row)){
                return true;
            }
            return false;
        },
        getValue: function (row) {
            return row['extension_attributes']['product_badge'];
        },
        getClasses: function (row) {
            return 'product-item__badge product-item__badge--' + this.getValue(row).replace(/ /g, '');
        },
        getAllBadges: function(row) {
            var values = this.getValue(row);
            // sometimes we receive a single value and sometimes an array
            if(Array.isArray(values)){
                return this.convertToLowercase(this.getValue(row))
            }
            // best to move this logic in one place
            values = values.toLowerCase();

            // force return of an array because of knockout's foreach
            return [values];
        },
        convertToLowercase: function(row) {
            return row.map(function(data){
                return data.toLowerCase();
            });
        }
    });
});
