<?php
namespace Asics\CustomPatch\Setup\Patch\Data;

use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Cms\Api\BlockRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Data Patch to update the `navigation_mobile_bottom_links` CMS block.
 *
 * This patch replaces the old "Log In | Join OneASICS" link
 * with two new links that depend on customer login state:
 *  - logged-out: "Log In | Join OneASICS"
 *  - logged-in: "My OneASICS Account"
 *
 * All existing PageBuilder markup and styles are preserved.
 */
class UpdateNavigationBottomLinks implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var BlockRepositoryInterface
     */
    private $blockRepository;

    /**
     * UpdateNavigationBottomLinks constructor.
     *
     * @param ModuleDataSetupInterface  $moduleDataSetup
     * @param BlockRepositoryInterface  $blockRepository
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        BlockRepositoryInterface $blockRepository
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->blockRepository = $blockRepository;
    }

    /**
     * Apply the data patch.
     *
     * This method loads the CMS block by identifier, searches for the
     * original login link, and replaces it with the new logged-in/logged-out links.
     *
     * @return void
     */
    public function apply()
    {
        $this->moduleDataSetup->startSetup();

        $blockIdentifier = 'navigation_mobile_bottom_links';

        $search = '&lt;a class="mobile-menu__bottom-link" href="/nz/en-nz/customer/account/"&gt;Log In | Join OneASICS&lt;/a&gt;';
        $replace = '&lt;a class="mobile-menu__bottom-link logged-out" href="/nz/en-nz/customer/account/"&gt;Log In | Join OneASICS&lt;/a&gt;' . "\n"
                 . '&lt;a class="mobile-menu__bottom-link logged-in" href="/nz/en-nz/customer/account/"&gt;My OneASICS Account&lt;/a&gt;';

        try {
            $block = $this->blockRepository->getById($blockIdentifier);
            $current = $block->getContent();

            if (strpos($current, $search) !== false) {
                $newContent = str_replace($search, $replace, $current);
                $block->setContent($newContent);
                $this->blockRepository->save($block);
            }
        } catch (NoSuchEntityException $e) {
            // Block not found, do nothing
        }

        $this->moduleDataSetup->endSetup();
    }

    /**
     * Declare other data patches that must be executed before this patch.
     *
     * @return array
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * Declare aliases for this patch (if it replaces another patch).
     *
     * @return array
     */
    public function getAliases()
    {
        return [];
    }
}
