<?php
namespace Asics\Verifone\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

class Configuration extends AbstractHelper
{
    const VERIFONE_PATH = "payment/verifone_hosted/";

    /**
     * Returns the logo source
     *
     * @param string $logoPrefix
     * @param string|null $storeId
     * @return string
     */
    public function getLogoSource($logoPrefix, $storeId = null)
    {
        return $this->_getVerifoneStoreConfig($logoPrefix . "Source", $storeId);
    }

    /**
     * Returns the logo alternative text
     *
     * @param string $logoPrefix
     * @param string|null $storeId
     * @return string
     */
    public function getLogoAlt($logoPrefix, $storeId = null)
    {
        return $this->_getVerifoneStoreConfig($logoPrefix . "Alt", $storeId);
    }

    /**
     * Returns the logo height
     *
     * @param string $logoPrefix
     * @param string|null $storeId
     * @return int
     */
    public function getLogoHeight($logoPrefix, $storeId = null)
    {
        return (int)$this->_getVerifoneStoreConfig($logoPrefix . "Height", $storeId);
    }

    /**
     * Returns the logo width
     *
     * @param string $logoPrefix
     * @param string|null $storeId
     * @return int
     */
    public function getLogoWidth($logoPrefix, $storeId = null)
    {
        return (int)$this->_getVerifoneStoreConfig($logoPrefix . "Width", $storeId);
    }

    /**
     * Returns Verifone store configuration value by name
     * 
     * @param $configName
     * @param $storeId
     * @return mixed
     */
    public function _getVerifoneStoreConfig($configName, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            self::VERIFONE_PATH . $configName,
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }
}
