define([
    'jquery',
    'underscore',
    'knockout',
    'mage/translate',
    'Magento_PageBuilder/js/events',
    'Magento_PageBuilder/js/content-type/preview',
    'Magento_PageBuilder/js/uploader',
    'Magento_PageBuilder/js/config',


], function (
    $,
    _,
    ko,
    $t,
    events,
    PreviewBase,
    uploader,
    config,

    ) {
    'use strict';

    /**
     * @param parent
     * @param config
     * @param stageId
     * @constructor
     */
    function Preview(parent, config, stageId) {
        PreviewBase.call(this, parent, config, stageId);
    }

    Preview.prototype = Object.create(PreviewBase.prototype);

    Preview.prototype.uploader = null;


    Preview.prototype.bindEvents = function bindEvents() {
        var self = this;

        PreviewBase.prototype.bindEvents.call(this);




          /**
           * Bind events for image uploading API
           */

          events.on(this.config.name + ":" + this.contentType.id + ":updateAfter", function () {
              var dataStore = self.contentType.dataStore.getState();

              var files = dataStore[self.config.additional_data.uploaderConfig.dataScope];
              var imageObject = files ? files[0] : {};

              events.trigger("image:" + self.contentType.id + ":assignAfter", imageObject);
          });

          events.on(this.config.name + ":mountAfter", function () {
              var dataStore = self.contentType.dataStore.getState();

              var initialImageValue = dataStore[self.config.additional_data.uploaderConfig.dataScope] || "";

              self.uploader = new uploader(
                  "imageuploader_" + self.contentType.id,
                  self.config.additional_data.uploaderConfig,
                  self.contentType.id,
                  self.contentType.dataStore,
                  initialImageValue
              );
          });

    };


      /** Return a new instance of the uploader to allow for inline image uploading capabilities
      *
      * @returns {*}
      */
      Preview.prototype.getUploader = function () {
          var initialImageValue = this.contentType.dataStore
              .get(this.config.additional_data.uploaderConfig.dataScope, "");

          return new uploader(
              "imageuploader_" + this.contentType.id,
              this.config.additional_data.uploaderConfig,
              this.contentType.id,
              this.contentType.dataStore,
              initialImageValue,
          );
      };





    /**
     * Check if content type is container
     *
     * @returns {boolean}
     */
    Preview.prototype.isContainer = function () {
        return false;
    };

    return Preview;
});
