<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace BrittainWynyard\CatalogAttributes\Setup\Patch\Data;

use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;

class AddAsicsTechnologiesProductAttribute implements DataPatchInterface, PatchRevertableInterface
{

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;
    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * Constructor
     *
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            'asics_technologies',
            [
                'type' => 'varchar',
                'label' => 'Technologies',
                'input' => 'multiselect',
                'source' => '',
                'frontend' => '',
                'required' => false,
                'backend' => 'Magento\Eav\Model\Entity\Attribute\Backend\ArrayBackend',
                'sort_order' => '30',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'default' => null,
                'visible' => true,
                'user_defined' => true,
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => true,
                'unique' => false,
                'apply_to' => '',
                'group' => 'General',
                'used_in_product_listing' => false,
                'is_used_in_grid' => true,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'option' => array('values' => array("6 STUDDED OUTSOLE","8 STUDDED OUTSOLE","ADAPT MESH TECHNOLOGY","AHAR HEEL PLUG","AHAR HERRINGBONE OUTSOLE","AHAR OUTSOLE","AHAR PLUS OUTSOLE","AHAR RUBBER SPONGE OUTSOLE","AIR MESH UPPER","AMPLIFOAM MIDSOLE","ANTI GRAVEL TONGUE","ASICS GRIP OUTSOLE","BREATHABLE MESH UPPER","BUNION WINDOW","CALF LEATHER VAMP","DISCRETE EYELETS","DUOMAX SUPPORT SYSTEM","DUOSOLE OUTSOLE","DUOTRUSS","DYNAMIC DUOMAX SUPPORT SYSTEM","DYNAMIC FOREFOOT CRADLE","ELASTIC LACES","ENGINEERED JACQUARD MESH UPPER","ENGINEERED MESH","EVA MIDSOLE","EVA MOULDED SOCKLINER","EXTENDED DUOMAX","EXTERNAL HEEL CLUTCH","FLEXION FIT UPPER","FLUIDFIT UPPER","FLUIDRIDE MIDSOLE","FLYTEFOAM BLAST MIDSOLE","FLYTEFOAM BOTTOM LAYER MIDSOLE","FLYTEFOAM HEEL CARTRIDGE","FLYTEFOAM LYTE","FLYTEFOAM PROPEL","FLYTEFOAM PROPEL TOP LAYER","FLYTEFOAM TECHNOLOGY","FOUR-WAY STRETCH UPPER","FULL GROUND CONTACT","FULL RUBBER OUTSOLE","GECKOTRAC TECHNOLOGY","GEL","GEL - FOREFOOT","GEL - FOREFOOT TWIST","GEL - REARFOOT","GEL - REARFOOT AND FOREFOOT","GEL - REARFOOT AND FOREFOOT TWIST","GEL - VISIBLE FOREFOOT AND REARFOOT","GEL - VISIBLE REARFOOT","GORE-TEX UPPER","GRIP RUBBER","GUB RUBBER OUTSOLE","GUIDANCE LINE","GUIDANCE TRUSSTIC SYSTEM TECHNOLOGY","GUIDESOLE TECHNOLOGY","GUM RUBBER OUTSOLE","GUSSET TONGUE","HG10MM","HOOK AND LOOP FASTENER","I.G.S TECHNOLOGY (MULTI-SPORTS)","I.G.S TECHNOLOGY (RUNNING)","INJECTION NYLON OUTSOLE","INJECTION PU OUTSOLE (3 DENSITY)","INJECTION SOLYTE POLYMER OUTSOLE (DUAL D","INTERNAL HEEL COUNTER","KANGAROO LEATHER UPPER","LACE GARAGE TECHNOLOGY","LATERAL PROPULSION TRUSSTIC","MEDIAL AND LATERAL OUTSOLE WRAPPING","MEDIAL OUTSOLE WRAPPING","MESH LASTING","MIDSOLE WRAP","MONO-SOCK TECHNOLOGY FIT SYSTEM","MOULDED LIGHT AHAR SPONGE OUTSOLE","MULTI STUD CONFIGURATION","NO-SEW REINFORCEMENT","NUBUCK UPPER","OCTOPOD OUTSOLE PATTERN","OPEN MESH UPPER","ORTHOLITE LASTING","ORTHOLITE SOCKLINER","PERFORATED SOCKLINER UPPER TECHNOLOGY","PERFORMANCE KNIT UPPER","PGUARD TOE PROTECTOR","PROPULSION TRUSSTIC TECHNOLOGY","REFLECTIVITY","REINFORCED STITCHED TOE CAP","REMOVABLE EVA SOCKLINER","REMOVABLE 'ORTHOLITE' MOULDED SOCKLINER","REMOVABLE SOCKLINER","ROCK PROTECTION PLATE","SOLID RUBBER OUTSOLE","SOLYTE 45 LASTING","SOLYTE 55 LASTING","SOLYTE 65 LASTING","SOLYTE MIDSOLE MATERIAL","SOLYTE POLYMER OUTSOLE","SPEVA 45 LASTING","SPEVA 55 LASTING","SPEVAFOAM MIDSOLE","SPEVAFOAM MIDSOLE TOP LAYER","STITCHED DOWN TOE BUMPER","SUPER AHAR HEEL PLUG","TEIJIN JAPANESE SYNTHETIC UPPER","TOUGHENED SYNTHETIC UPPER","TRAIL SPECIFIC OUTSOLE","TRUSSTIC","TWISTRUSS","UPHILL/DOWNHILL TRACTION","WATER RESISTANCE","WIDTH SPECIFIC"))
            ]
        );

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    public function revert()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY, 'asics_technologies');

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [
        
        ];
    }
}

