<?php
namespace Overdose\Catalog\Setup\Patch\Data;

use Magento\Eav\Api\AttributeManagementInterface;
use Magento\Eav\Model\Entity\AttributeFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Eav\Api\AttributeOptionManagementInterface;
use Magento\Eav\Model\ResourceModel\Entity\Attribute as ResourceModel;
use Psr\Log\LoggerInterface;

class AddBadgeAttributeOptions implements DataPatchInterface
{
    const ATTRIBUTE_CODE = 'product_badge';

    /**
     * @var AttributeManagementInterface
     */
    private $attributeManagement;

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var AttributeOptionManagementInterface
     */
    private $attributeOptionManagement;

    /**
     * @var AttributeFactory
     */
    private $eavAttributeFactory;

    /**
     * @var ResourceModel
     */
    private $resourceModel;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * SellableFormatCatalogAttribute constructor.
     *
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param AttributeManagementInterface $attributeManagement
     * @param AttributeOptionManagementInterface $attributeOptionManagement
     * @param AttributeFactory $eavAttributeFactory
     * @param ResourceModel $resourceModel
     * @param LoggerInterface $logger
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        AttributeManagementInterface $attributeManagement,
        AttributeOptionManagementInterface $attributeOptionManagement,
        AttributeFactory $eavAttributeFactory,
        ResourceModel $resourceModel,
        LoggerInterface $logger
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->attributeManagement = $attributeManagement;
        $this->attributeOptionManagement = $attributeOptionManagement;
        $this->eavAttributeFactory = $eavAttributeFactory;
        $this->resourceModel = $resourceModel;
        $this->logger = $logger;
    }

    /**
     * @return $this
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        try {
            $this->addOptions();
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
        $this->moduleDataSetup->getConnection()->endSetup();
        return $this;
    }

    private function addOptions()
    {
        $attribute = $this->eavAttributeFactory->create()
            ->loadByCode(\Magento\Catalog\Model\Product::ENTITY, self::ATTRIBUTE_CODE);
        $magentoAttributeOptions = $this->attributeOptionManagement->getItems(
            'catalog_product',
            self::ATTRIBUTE_CODE
        );

        $attributeOptions = ['New', 'Exclusive', 'Coming Soon', 'Lottery', 'Outlet', 'Sale'];
        $existingMagentoAttributeOptions = [];
        $newOptions = [];
        $counter = 0;

        foreach($magentoAttributeOptions as $option) {
            if (!$option->getValue()) {
                continue;
            }
            if ($option->getLabel() instanceof \Magento\Framework\Phrase) {
                $label = $option->getText();
            } else {
                $label = $option->getLabel();
            }
            if ($label == '') {
                continue;
            }
            $existingMagentoAttributeOptions[] = $label;
            $newOptions['value'][$option->getValue()] = [$label, $label];
            $counter++;
        }

        foreach ($attributeOptions as $option) {
            if ($option == '') {
                continue;
            }
            if (!in_array($option, $existingMagentoAttributeOptions)) {
                $newOptions['value']['option_'.$counter] = [$option, $option];
            }
            $counter++;
        }

        if (count($newOptions)) {
            $attribute->setOption($newOptions);
            $this->resourceModel->save($attribute);
        }
    }

    /**
     * return array
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * return array
     */
    public function getAliases()
    {
        return [];
    }
}
