<?php
namespace Overdose\CatalogAttribute\Plugin\Magento\Catalog\Model\Category;

use Magento\Eav\Model\Config;

class DataProvider
{
    //function beforeMETHOD($subject, $arg1, $arg2){}
    //function aroundMETHOD($subject, $procede, $arg1, $arg2){return $proceed($arg1, $arg2);}
    //function afterMETHOD($subject, $result){return $result;}
    protected $eavConfig;
    public function __construct(
        Config $eavConfig)
    {
        $this->eavConfig = $eavConfig;
    }

    public function afterPrepareMeta($subject, $meta)
    {
        $meta = array_replace_recursive($meta, $this->prepareFieldsMeta(
            $this->getFieldsMap(),
            $subject->getAttributesMeta($this->eavConfig->getEntityType('catalog_category'))
        ));

        return $meta;
    }

    public function getFieldsMap()
    {
        return [
            'menu' => [
                'bottom_descriptions',
            ],
        ];
    }

    private function prepareFieldsMeta($fieldsMap, $fieldsMeta)
    {
        $result = [];
        foreach ($fieldsMap as $fieldSet => $fields) {
            foreach ($fields as $field) {
                if (isset($fieldsMeta[$field])) {
                    $result[$fieldSet]['children'][$field]['arguments']['data']['config'] = $fieldsMeta[$field];
                }
            }
        }
        return $result;
    }
}
