<?php

namespace Overdose\InventoryShipping\Helper;

use Overdose\InventoryShipping\Model\ResourceModel\OrderSource\GetOrderSourceCodesByOrderId;

class OrderSource
{
    private GetOrderSourceCodesByOrderId $getOrderSourceCodesByOrderId;

    /**
     * @param GetOrderSourceCodesByOrderId $getOrderSourceCodesByOrderId
     */
    public function __construct(
        GetOrderSourceCodesByOrderId $getOrderSourceCodesByOrderId
    ) {
        $this->getOrderSourceCodesByOrderId = $getOrderSourceCodesByOrderId;
    }

    /**
     * Get array of order source codes
     *
     * @param int $orderId
     * @return array
     */
    public function getOrderSourceCodesByOrderId(int $orderId): array
    {
        $sourceCodes = [];
        $orderSourceCodes = $this->getOrderSourceCodesByOrderId->execute($orderId);
        foreach ($orderSourceCodes as $sourceData) {
            foreach ($sourceData as $source) {
                $sourceCodes[] = $source['sourceCode'];
            }
        }
        return array_values(array_unique($sourceCodes));
    }
}
