<?php

declare(strict_types=1);

namespace Overdose\ProductBanners\Helper;

use Magento\Store\Model\ScopeInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     *  Path to status module
     */
    const XML_PATH_STATUS = 'overdose_product_banner/general/enable';

    /**
     *  Path to config if product should be excluded from search page
     */
    const XML_PATH_BANNER_VISIBILITY = 'overdose_product_banner/general/search_exclude';

    /**
     *  Path to product item selector
     */
    const XML_PATH_PRODUCT_ITEM_SELECTOR = 'overdose_product_banner/theme_settings/product_item_selector';

    /**
     *  Path to selector which will be hide in product item via js
     */
    const XML_PATH_SELECTOR_TO_HIDE = 'overdose_product_banner/theme_settings/selector_to_hide';

    /**
     *  Path to config use description instead product image
     */
    const XML_PATH_USE_DESCRIPTION_INSTEAD_PRODUCT_IMAGE = 'overdose_product_banner/theme_settings/use_description_instead_product_image';

    /**
     *  Path to config is banner product sensitive for filter
     */
    const XML_PATH_IS_FILTER_SENSITIVE = 'overdose_product_banner/general/is_filter_sensitive';

    /**
     * Returns status module
     *
     * @return bool
     */
    public function isEnabled()
    {
        return $this->scopeConfig->isSetFlag(static::XML_PATH_STATUS);
    }

    /**
     * Returns if banner product should be excluded from search
     *
     * @return bool
     */
    public function isExcludedFromSearch()
    {
        return $this->scopeConfig->isSetFlag(static::XML_PATH_BANNER_VISIBILITY);
    }

    /**
     * Returns selector of product item in listing
     *
     * @return string
     */
    public function getProductItemSelector()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_PRODUCT_ITEM_SELECTOR);
    }

    /**
     * Return css selector for hide from page via js
     *
     * @return string
     */
    public function getSelectorToHide()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SELECTOR_TO_HIDE);
    }

    /**
     * Return is need change product image to product description instead
     *
     * @return bool
     */
    public function IsUseDescriptionInsteadProductImage()
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_USE_DESCRIPTION_INSTEAD_PRODUCT_IMAGE);
    }

    /**
     * @return \Psr\Log\LoggerInterface
     */
    public function getLogger()
    {
        return $this->_logger;
    }

    /**
     * @param int $storeId
     * @return mixed
     */
    public function isFilterSensitive($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_IS_FILTER_SENSITIVE, ScopeInterface::SCOPE_STORE, $storeId);
    }
}
