<?php

declare(strict_types=1);

namespace Overdose\ProductBanners\Plugin\Catalog\Block\Product;

use Magento\Catalog\Block\Product\AwareInterface as ProductAwareInterface;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;

class ListProduct
{
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    protected $productRepository;

    /**
     * @var \Overdose\ProductBanners\Helper\Data
     */
    protected $bannerHelper;

    /**
     * @param \Overdose\ProductBanners\Helper\Data $bannerHelper
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     */
    public function __construct(
        \Overdose\ProductBanners\Helper\Data $bannerHelper,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
    ) {
        $this->bannerHelper = $bannerHelper;
        $this->productRepository = $productRepository;
    }

    /**
     *  Banner haven't price
     *
     * @param \Magento\Catalog\Block\Product\ListProduct $subject
     * @param string $result
     * @param \Magento\Catalog\Model\Product $product
     * @return string
     * @see \Magento\Catalog\Block\Product\ListProduct::getProductPrice
     */
    public function afterGetProductPrice(
        \Magento\Catalog\Block\Product\ListProduct $subject,
        string $result,
        \Magento\Catalog\Model\Product $product
    ) {
        if ($product->getTypeId() === \Overdose\ProductBanners\Model\Product\Type\Banner::PRODUCT_TYPE_BANNER) {
            return '';
        }

        return $result;
    }

    /**
     *  Change product image to block (\Overdose\ProductBanners\Block\Category\Banner)
     *
     * @param \Magento\Catalog\Block\Product\ListProduct $subject
     * @param \Magento\Catalog\Block\Product\Image $result
     * @param \Magento\Catalog\Model\Product $product
     * @param string $imageId
     * @param array $attributes
     * @return \Overdose\ProductBanners\Block\Category\Banner|\Magento\Catalog\Block\Product\Image
     * @throws LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @see \Magento\Catalog\Block\Product\AbstractProduct::getImage
     */
    public function afterGetImage(
        \Magento\Catalog\Block\Product\ListProduct $subject,
        \Magento\Catalog\Block\Product\Image $result,
        \Magento\Catalog\Model\Product $product,
        string $imageId,
        array $attributes = []
    ) {
        if (
            $product->getTypeId() === \Overdose\ProductBanners\Model\Product\Type\Banner::PRODUCT_TYPE_BANNER &&
            $this->bannerHelper->IsUseDescriptionInsteadProductImage()
        ) {
            /** @var \Overdose\ProductBanners\Block\Category\Banner $bannerContent */
            $bannerContent = $subject->getChildBlock('banner_content');
            if ($bannerContent instanceof ProductAwareInterface) {
                $product = $this->productRepository->getById($product->getId());
                return $bannerContent->setProduct($product);
            } elseif ($bannerContent instanceof DataObject) {
                $this->bannerHelper->getLogger()->info('banner_content block doesn\'t implement AwareInterface', $bannerContent->getData());
            } else {
                $this->bannerHelper->getLogger()->info('Can\'t load banner content block');
            }
        }

        return $result;
    }

}
