define([
    'jquery',
    'domReady!'
], function ($) {
    'use strict';

    var innerBannerSelector = '.banner-block-item',
        topItemBannerClass = 'banner-product';

    function addClassToTopItemContainer(ItemContainerSelector) {
        $(innerBannerSelector).each(function (i, innerBanner) {
            $(innerBanner).closest(ItemContainerSelector).addClass(topItemBannerClass);
        });
    }

    function hideElementFromBanner(selectorToHide) {
        $('.'+topItemBannerClass).find(selectorToHide).hide();
    }

    function resetImageSource(url) {
        let urlparts = url.split('?');
        if (urlparts.length>=2) {
            let width = encodeURIComponent('width')+'=';
            let height = encodeURIComponent('height')+'=';
            let pars = urlparts[1].split(/[&;]/g);
            for (let i = pars.length; i-- > 0;) {
                if ((pars[i].lastIndexOf(width, 0) !== -1) || (pars[i].lastIndexOf(height, 0) !== -1)) {
                    pars.splice(i, 1);
                }
            }
            url= urlparts[0]+'?'+pars.join('&');
            return url;
        } else {
            return url;
        }
    }

    function removeImageSize(ItemContainerSelector) {
        let images = $(innerBannerSelector).closest(ItemContainerSelector).find('.product-image-photo');
        images.each(function (i, image) {
            let newSrc = resetImageSource($(image).attr('src'));
            $(image).attr('src', newSrc);
        });
    }

    return function (config) {
        addClassToTopItemContainer(config.productItemSelector);
        removeImageSize(config.productItemSelector);
        hideElementFromBanner(config.selectorToHide);
    };
});
