<?php

namespace Overdose\ShoeFinder\Block;

use Magento\Framework\View\Element\Template;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Class ShoeFinder
 * @package Overdose\ShoeFinder\Block
 */
class ShoeFinder extends Template
{
    const XML_PATH_ENABLED = 'shoe_finder/general/enabled';
    const XML_PATH_ALLOWED_ACTIONS = 'shoe_finder/general/allowed_actions';
    
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    
    /**
     * @param Template\Context $context
     * @param ScopeConfigInterface $scopeConfig
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        ScopeConfigInterface $scopeConfig,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->scopeConfig = $scopeConfig;
    }
    
    /**
     * @param $image
     * @return string
     */
    public function getImageUrl($image)
    {
        return $this->getViewFileUrl('Overdose_ShoeFinder::media/' . $image);
    }

    /**
     * @return string
     */
    public function getFindingUrl()
    {
        return $this->getUrl('shoe-finder/index/find');
    }

    /**
     * @return bool
     */
    public function isShowFinderTab()
    {
        if (!$this->isShoeFinderEnabled()) {
            return false;
        }
        
        return $this->isControllerWhitelisted();
    }

    /**
     * Check if Shoe Finder feature is enabled
     *
     * @return bool
     */
    private function isShoeFinderEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_ENABLED, ScopeInterface::SCOPE_STORE);
    }

    /**
     * Check if current controller action is in the whitelist
     *
     * @return bool
     */
    private function isControllerWhitelisted()
    {
        // Get allowed actions from config
        $allowedActionsConfig = $this->scopeConfig->getValue(
            self::XML_PATH_ALLOWED_ACTIONS,
            ScopeInterface::SCOPE_STORE
        );

        // Parse comma-separated values and trim whitespace
        $allowedActions = [];
        if ($allowedActionsConfig) {
            $allowedActions = array_map('trim', explode(',', $allowedActionsConfig));
            $allowedActions = array_filter($allowedActions); // Remove empty values
        }
        
        // If no allowed actions configured, don't show
        if (empty($allowedActions)) {
            return false;
        }
        
        // Check if current action is in the allowed list
        $fullActionName = $this->getRequest()->getFullActionName();
        return in_array($fullActionName, $allowedActions);
    }
}
