<?php

namespace VerifoneEcomAPI\ApiWrapper;

use Verifone\Hosted\Helper\Verifone;

/**
 * Class Settings
 * @package VerifoneEcomAPI\ApiWrapper
 */
class Settings
{
    const PAYMENT_TYPE_HPP = 'hpp';
    const PAYMENT_TYPE_IFRAME = 'iframe';

    const TRANSACTION_TYPE_PRE_AUTH = 'pre_auth';
    const TRANSACTION_TYPE_AUTH = 'auth';
    const TRANSACTION_TYPE_SALE = 'sale';

    const AUTH_TYPE_PRE_AUTH = 'PRE_AUTH';
    const AUTH_TYPE_FINAL_AUTH = 'FINAL_AUTH';

    const INVOICE_4U_RECEIPT_TYPE_INVOICE='INVOICE';
    const INVOICE_4U_RECEIPT_TYPE_FULL_RECEIPT='FULL_RECEIPT';
    const INVOICE_4U_RECEIPT_TYPE_INVOICE_RECEIPT='INVOICE_RECEIPT';

    private $test;
    private $region;
    private $api_user;
    private $api_key;
    private $isCardEnabled;
    private $_3ds_enable;
    private $payment_contract_id;
    private $_3ds_contract_id;
    private $entity_id;
    private $fraud_check;
    private $fraud_check_contract_id;
    private $curl_verify_ssl;
    private $order_status;
    private $set_order_before_redirect;
    private $overlay_on_place_order;
    private $complete_order_on_payment;
    private $authType;
    private $isManualCapture;
    private $transactionType;
    private $paymentType;
    private $paypalContractId;
    private $googlePayContractId;
    private $applePayContractId;

    private $isPaypalEnabled;
    private $isGooglePayEnabled;
    private $isApplePayEnabled;
    private $google_pay_sca_compliance_level;
    private $google_pay_threeds_contract_id;

    private $apple_pay_sca_compliance_level;
    private $apple_pay_threeds_contract_id;

    private $isSwishEnabled;
    private $isKlarnaEnabled;

    private $gpp2_enabled;
    private $gpp2_contract_id;

    private $theme_id;

    private $abs_installments_enabled;
    private $abs_installments_thresholds;

    private $vippsEnabled;
    private $vippsContractId;
    private $vippsScaLevel;
    private $vipps3DSContractId;

    private $mobilePayEnabled;
    private $mobilePayContractId;
    private $mobilePayScaLevel;
    private $mobilePay3DSContractId;


    private $invoice4uEnabled;
    private $invoice4uSendTaxRates;
    private $invoice4uReceiptType;

    /**
     * @return mixed
     */
    public function getMobilePayEnabled()
    {
        return $this->mobilePayEnabled;
    }

    /**
     * @param  mixed  $mobilePayEnabled
     *
     * @return Settings
     */
    public function setMobilePayEnabled($mobilePayEnabled)
    {
        $this->mobilePayEnabled = $mobilePayEnabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getMobilePayContractId()
    {
        return $this->mobilePayContractId;
    }

    /**
     * @param  mixed  $mobilePayContractId
     *
     * @return Settings
     */
    public function setMobilePayContractId($mobilePayContractId)
    {
        $this->mobilePayContractId = $mobilePayContractId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getMobilePayScaLevel()
    {
        return $this->mobilePayScaLevel;
    }

    /**
     * @param  mixed  $mobilePayScaLevel
     *
     * @return Settings
     */
    public function setMobilePayScaLevel($mobilePayScaLevel)
    {
        $this->mobilePayScaLevel = $mobilePayScaLevel;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getMobilePay3DSContractId()
    {
        return $this->mobilePay3DSContractId;
    }

    /**
     * @param  mixed  $mobilePay3DSContractId
     *
     * @return Settings
     */
    public function setMobilePay3DSContractId($mobilePay3DSContractId)
    {
        $this->mobilePay3DSContractId = $mobilePay3DSContractId;

        return $this;
    }


    /**
     * @return mixed
     */
    public function getVippsEnabled()
    {
        return $this->vippsEnabled;
    }

    /**
     * @param  mixed  $vippsEnabled
     *
     * @return Settings
     */
    public function setVippsEnabled($vippsEnabled)
    {
        $this->vippsEnabled = $vippsEnabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getVippsContractId()
    {
        return $this->vippsContractId;
    }

    /**
     * @param  mixed  $vippsContractId
     *
     * @return Settings
     */
    public function setVippsContractId($vippsContractId)
    {
        $this->vippsContractId = $vippsContractId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getVippsScaLevel()
    {
        return $this->vippsScaLevel;
    }

    /**
     * @param  mixed  $vippsScaLevel
     *
     * @return Settings
     */
    public function setVippsScaLevel($vippsScaLevel)
    {
        $this->vippsScaLevel = $vippsScaLevel;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getVipps3DSContractId()
    {
        return $this->vipps3DSContractId;
    }

    /**
     * @param  mixed  $vipps3DSContractId
     *
     * @return Settings
     */
    public function setVipps3DSContractId($vipps3DSContractId)
    {
        $this->vipps3DSContractId = $vipps3DSContractId;

        return $this;
    }


    /**
     * @return mixed
     */
    public function getIsKlarnaEnabled()
    {
        return $this->isKlarnaEnabled;
    }

    /**
     * @param  mixed  $isKlarnaEnabled
     *
     * @return Settings
     */
    public function setIsKlarnaEnabled($isKlarnaEnabled)
    {
        $this->isKlarnaEnabled = $isKlarnaEnabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getIsSwishEnabled()
    {
        return $this->isSwishEnabled;
    }

    /**
     * @param  mixed  $isSwishEnabled
     *
     * @return Settings
     */
    public function setIsSwishEnabled($isSwishEnabled)
    {
        $this->isSwishEnabled = $isSwishEnabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getApplePayScaComplianceLevel()
    {
        return $this->apple_pay_sca_compliance_level;
    }

    /**
     * @param  mixed  $apple_pay_sca_compliance_level
     *
     * @return Settings
     */
    public function setApplePayScaComplianceLevel($apple_pay_sca_compliance_level)
    {
        $this->apple_pay_sca_compliance_level = $apple_pay_sca_compliance_level;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getApplePayThreedsContractId()
    {
        return $this->apple_pay_threeds_contract_id;
    }

    /**
     * @param  mixed  $apple_pay_threeds_contract_id
     *
     * @return Settings
     */
    public function setApplePayThreedsContractId($apple_pay_threeds_contract_id)
    {
        $this->apple_pay_threeds_contract_id = $apple_pay_threeds_contract_id;

        return $this;
    }

    /**
     * @param  mixed  $theme_id
     *
     * @return Settings
     */
    public function setThemeId($theme_id)
    {
        $this->theme_id = $theme_id;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getGooglePayThreedsContractId()
    {
        return $this->google_pay_threeds_contract_id;
    }

    /**
     * we return the theme_id only if it's a valid UUID
     * @return mixed
     */
    public function getThemeId()
    {
        if (! is_string($this->theme_id) ||
             (preg_match('/^[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/', $this->theme_id) !== 1)) {
            return null;
        }

        return $this->theme_id;
    }

    /**
     * @param  mixed  $google_pay_threeds_contract_id
     *
     * @return Settings
     */
    public function setGooglePayThreedsContractId($google_pay_threeds_contract_id)
    {
        $this->google_pay_threeds_contract_id = $google_pay_threeds_contract_id;

        return $this;
    }


    /**
     * @return mixed
     */
    public function getGooglePayScaComplianceLevel()
    {
        return $this->google_pay_sca_compliance_level;
    }

    /**
     * @param  mixed  $google_pay_sca_compliance_level
     *
     * @return Settings
     */
    public function setGooglePayScaComplianceLevel($google_pay_sca_compliance_level)
    {
        $this->google_pay_sca_compliance_level = $google_pay_sca_compliance_level;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getIsPaypalEnabled()
    {
        return $this->isPaypalEnabled;
    }

    /**
     * @param  mixed  $isPaypalEnabled
     *
     * @return Settings
     */
    public function setIsPaypalEnabled($isPaypalEnabled)
    {
        $this->isPaypalEnabled = $isPaypalEnabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getIsGooglePayEnabled()
    {
        return $this->isGooglePayEnabled;
    }

    /**
     * @param  mixed  $isGooglePayEnabled
     *
     * @return Settings
     */
    public function setIsGooglePayEnabled($isGooglePayEnabled)
    {
        $this->isGooglePayEnabled = $isGooglePayEnabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getIsApplePayEnabled()
    {
        return $this->isApplePayEnabled;
    }

    /**
     * @param  mixed  $isApplePayEnabled
     *
     * @return Settings
     */
    public function setIsApplePayEnabled($isApplePayEnabled)
    {
        $this->isApplePayEnabled = $isApplePayEnabled;

        return $this;
    }


    /**
     * @return mixed
     */
    public function getPaypalContractId()
    {
        return $this->paypalContractId;
    }

    /**
     * @param  mixed  $paypalContractId
     *
     * @return Settings
     */
    public function setPaypalContractId($paypalContractId)
    {
        $this->paypalContractId = $paypalContractId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getGooglePayContractId()
    {
        return $this->googlePayContractId;
    }

    /**
     * @param  mixed  $googlePayContractId
     *
     * @return Settings
     */
    public function setGooglePayContractId($googlePayContractId)
    {
        $this->googlePayContractId = $googlePayContractId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getApplePayContractId()
    {
        return $this->applePayContractId;
    }

    /**
     * @param  mixed  $applePayContractId
     *
     * @return Settings
     */
    public function setApplePayContractId($applePayContractId)
    {
        $this->applePayContractId = $applePayContractId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }

    /**
     * @param  mixed  $paymentType
     *
     * @return Settings
     */
    public function setPaymentType($paymentType)
    {
        $this->paymentType = $paymentType;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }

    /**
     * @return mixed
     */
    public function getAuthType()
    {
        return $this->authType;
    }

    /**
     * default value must be 'FINAL_AUTH'
     *
     * @param  mixed  $isPreAuth
     *
     * @return $this
     */
    public function setAuthType($isPreAuth)
    {
        $this->authType = $isPreAuth ? self::AUTH_TYPE_PRE_AUTH : self::AUTH_TYPE_FINAL_AUTH;

        return $this;
    }

    /**
     * @return mixed
     */
    public function isManualCapture()
    {
        return $this->isManualCapture;
    }

    /**
     * @param  mixed  $isManualCapture
     *
     * @return $this
     */
    public function setManualCapture($isManualCapture)
    {
        $this->isManualCapture = $isManualCapture;

        return $this;
    }

    /**
     * @param  mixed  $transactionType
     *
     * @return Settings
     */
    public function setTransactionType($transactionType)
    {
        $this->transactionType = $transactionType;

        switch ($transactionType) {
            case self::TRANSACTION_TYPE_PRE_AUTH:
                $this->setAuthType(true);
                $this->setManualCapture(true);
                break;
            case self::TRANSACTION_TYPE_AUTH:
                $this->setAuthType(false);
                $this->setManualCapture(true);
                break;
            case self::TRANSACTION_TYPE_SALE:
            default:
                $this->setAuthType(false);
                $this->setManualCapture(false);
                break;
        }

        return $this;
    }

    /**
     * @return mixed
     */
    public function getOverlayOnPlaceOrder()
    {
        return $this->overlay_on_place_order;
    }

    /**
     * @param  mixed  $overlay_on_place_order
     *
     * @return $this
     */
    public function setOverlayOnPlaceOrder($overlay_on_place_order)
    {
        $this->overlay_on_place_order = $overlay_on_place_order;

        return $this;
    }

    /**
     * @return mixed
     */
    public function isFraudCheck()
    {
        return $this->fraud_check;
    }

    /**
     * @param  mixed  $fraud_check
     *
     * @return $this
     */
    public function setFraudCheck($fraud_check)
    {
        $this->fraud_check = $fraud_check;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getFraudCheckContractId()
    {
        return $this->fraud_check_contract_id;
    }

    /**
     * @param  mixed  $fraud_check_contract_id
     *
     * @return $this
     */
    public function setFraudCheckContractId($fraud_check_contract_id)
    {
        $this->fraud_check_contract_id = $fraud_check_contract_id;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getCurlVerifySsl()
    {
        return $this->curl_verify_ssl;
    }

    /**
     * @param  mixed  $curl_verify_ssl
     *
     * @return $this
     */
    public function setCurlVerifySsl($curl_verify_ssl)
    {
        $this->curl_verify_ssl = $curl_verify_ssl;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getEntityId()
    {
        return $this->entity_id;
    }

    /**
     * @param  mixed  $entity_id
     *
     * @return $this
     */
    public function setEntityId($entity_id)
    {
        $this->entity_id = $entity_id;

        return $this;
    }

    /**
     * @return mixed
     */
    public function get3dsContractId()
    {
        return $this->_3ds_contract_id;
    }

    /**
     * @param $contractId
     *
     * @return $this
     */
    public function set3dsContractId($contractId)
    {
        $this->_3ds_contract_id = $contractId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function isTest()
    {
        return $this->test;
    }

    /**
     * @return mixed
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @return mixed
     */
    public function getApiUserId()
    {
        return $this->api_user;
    }

    /**
     * @return mixed
     */
    public function getApiKey()
    {
        return $this->api_key;
    }

    public function getIsCardEnabled()
    {
        return $this->isCardEnabled;
    }

    /**
     * @return mixed
     */
    public function is3dsEnabled()
    {
        return $this->_3ds_enable;
    }

    /**
     * @return mixed
     */
    public function getDeviceType()
    {
        if (preg_match(
            '/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',
            $_SERVER['HTTP_USER_AGENT']
        ) || preg_match(
            '/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',
            substr($_SERVER['HTTP_USER_AGENT'], 0, 4)
        )) {
            return 'P';
        }

        return 'S';
    }

    /**
     * @return mixed
     */
    public function getPaymentContractId()
    {
        return $this->payment_contract_id;
    }

    /**
     * @return mixed
     */
    public function getCompleteOrderOnPayment()
    {
        return $this->complete_order_on_payment;
    }

    /**
     * @param  mixed  $test
     *
     * @return $this
     */
    public function setTest($test)
    {
        $this->test = $test;

        return $this;
    }

    /**
     * @param  mixed  $region
     *
     * @return $this
     */
    public function setRegion($region)
    {
        $this->region = $region;

        return $this;
    }

    /**
     * @param  mixed  $api_user
     *
     * @return $this
     */
    public function setApiUserId($api_user)
    {
        $this->api_user = $api_user;

        return $this;
    }

    /**
     * @param  mixed  $api_key
     *
     * @return $this
     */
    public function setApiKey($api_key)
    {
        $this->api_key = $api_key;

        return $this;
    }

    /**
     * @param $isCardEnabled
     *
     * @return $this
     */
    public function setIsCardEnabled($isCardEnabled)
    {
        $this->isCardEnabled = $isCardEnabled;

        return $this;
    }

    /**
     * @param $_3ds
     *
     * @return $this
     */
    public function set3dsEnable($_3ds)
    {
        $this->_3ds_enable = $_3ds;

        return $this;
    }

    /**
     * @param  mixed  $payment_contract_id
     *
     * @return $this
     */
    public function setPaymentContractId($payment_contract_id)
    {
        $this->payment_contract_id = $payment_contract_id;

        return $this;
    }

    /**
     * @param $complete_order_on_payment
     *
     * @return $this
     */
    public function setCompleteOrderOnPayment($complete_order_on_payment)
    {
        $this->complete_order_on_payment = $complete_order_on_payment;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getGpp2Enabled()
    {
        return $this->gpp2_enabled;
    }

    /**
     * @param  mixed  $gpp2_enabled
     *
     * @return $this
     */
    public function setGpp2Enabled($gpp2_enabled)
    {
        $this->gpp2_enabled = $gpp2_enabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getGpp2ContractId()
    {
        return $this->gpp2_contract_id;
    }

    /**
     * @param  mixed  $gpp2_contract_id
     *
     * @return $this
     */
    public function setGpp2ContractId($gpp2_contract_id)
    {
        $this->gpp2_contract_id = $gpp2_contract_id;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getAbsInstallmentsEnabled()
    {
        return $this->abs_installments_enabled;
    }

    /**
     * @param  mixed  $abs_installments_enabled
     */
    public function setAbsInstallmentsEnabled($abs_installments_enabled)
    {
        $this->abs_installments_enabled = $abs_installments_enabled;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getAbsInstallmentsThresholds()
    {
        return $this->abs_installments_thresholds;
    }

    /**
     * @param  mixed  $abs_installments_thresholds
     */
    public function setAbsInstallmentsThresholds($paymentMethod)
    {
        $this->abs_installments_thresholds = [];

        for ($i = 0; $i < 10; $i++) {
            if (isset($paymentMethod->getConfigData('card_settings')["abs_threshold_$i"])) {
                $min            = (float) ($paymentMethod->getConfigData('card_settings')["abs_threshold_$i"]["abs_installment_threshholds_min_$i"] ?? 0);
                $max            = (float) $paymentMethod->getConfigData('card_settings')["abs_threshold_$i"]["abs_installment_threshholds_max_$i"] ?? 0;
                $installmentsNo = (int) $paymentMethod->getConfigData('card_settings')["abs_threshold_$i"]["abs_installment_no_$i"] ?? 1;

                if ((0 === $i || $min) && $max && $installmentsNo) {
                    $this->abs_installments_thresholds[] = [
                        'min'             => $min,
                        'max'             => $max,
                        'installments_no' => $installmentsNo,
                    ];
                }
            }
        }

        return $this;
    }

    public function getAbsInstallmentsForAmount($amount)
    {
        $installmentsNo = 0;

        foreach ($this->abs_installments_thresholds as $absThreshold) {
            if ($amount >= $absThreshold['min'] && $amount <= $absThreshold['max']) {
                $installmentsNo = $absThreshold['installments_no'];
                break;
            }
        }

        return $installmentsNo;
    }

    public function getOrderStatus()
    {
        return $this->order_status;
    }

    public function getOrderState()
    {
        $status= $this->order_status;

        switch ($status) {
            case 'pending':
                return 'new';

            default:
                return $status;
        }
    }

    public function setOrderStatus($order_status): self
    {
        $this->order_status = $order_status;
        return $this;
    }

    public function isOrderBeforeRedirect()
    {
        return $this->set_order_before_redirect;
    }

    public function setOrderBeforeRedirect($set_order_before_redirect): self
    {
        $this->set_order_before_redirect = $set_order_before_redirect;
        return $this;
    }

    /**
     * @return string
     */
    public function getInvoice4uReceiptType()
    {
        return $this->invoice4uReceiptType;
    }

    /**
     * @param string $invoice4uReceiptType
     * @return self
     */
    public function setInvoice4uReceiptType($invoice4uReceiptType): self
    {
        $this->invoice4uReceiptType = $invoice4uReceiptType;
        return $this;
    }

    /**
     * @return bool
     */
    public function getIsInvoice4uEnabled()
    {
        return $this->invoice4uEnabled;
    }

    /**
     * @param bool $invoice4uEnabled
     * @return self
     */
    public function setInvoice4uEnabled($invoice4uEnabled): self
    {
        $this->invoice4uEnabled =(bool) $invoice4uEnabled;
        return $this;
    }

    /**
     * @return bool
     */
    public function getInvoice4uSendTaxRates()
    {
        return $this->invoice4uSendTaxRates;
    }

    /**
     * @param bool $invoice4uSendTaxRates
     * @return self
     */
    public function setInvoice4uSendTaxRates($invoice4uSendTaxRates): self
    {
        $this->invoice4uSendTaxRates =(bool) $invoice4uSendTaxRates;
        return $this;
    }
}
