define([
    'jquery',
    'Magento_Checkout/js/model/full-screen-loader',
    'mage/url',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/payment/additional-validators',
    'Magento_Checkout/js/action/redirect-on-success',
    'Magento_Checkout/js/checkout-data'
], function ($, fullScreenLoader, url, quote, additionalValidators, redirectOnSuccessAction, checkoutData) {
    'use strict';

    /**
     * Newsletter subscription after order placement.
     */
    var mixins = {
        getEmail: function () {
            return window.isCustomerLoggedIn
                ? window.customerData.email
                : quote.guestEmail
        },

        checkoutNewsletterSubcriber: function () {
            var self = this;
            var addToNewsletterUrl = url.build('ajaxnewsletter/index/index');
            var checked = Boolean($('[name="newsletter-subscribe"]').attr('checked'));
            if (checked) {
                $.ajax({
                    type: 'POST',
                    url: addToNewsletterUrl,
                    data: {
                        'email': self.getEmail()
                    },
                    async: false
                }).always(function() {
                });
            }
        },

        /**
         * Place order.
         */
        placeOrder: function (data, event) {
            var self = this;
            if (event) {
                event.preventDefault();
            }
            if (this.validate() &&
                additionalValidators.validate() &&
                this.isPlaceOrderActionAllowed() === true
            ) {
                this.isPlaceOrderActionAllowed(false);
                this.getPlaceOrderDeferredObject()
                    .done(
                        function () {
                            self.checkoutNewsletterSubcriber();
                            self.afterPlaceOrder();
                            if (self.redirectAfterPlaceOrder) {
                                redirectOnSuccessAction.execute();
                            }
                        }
                    ).always(
                        function () {
                            self.isPlaceOrderActionAllowed(true);
                        }
                    );
                return true;
            }
            return false;
        },
    };

    return function (target) {
        return target.extend(mixins);
    };
});
