define([
    'jquery',
    'ko',
    'Magento_Checkout/js/model/quote'
], function ($, ko, quote) {
    'use strict';

    var self = this;

    var mixin = {
        /**
         * "this.elems()" - list of addresses components
         * "element.address()" - is address object: Magento_Checkout/js/view/shipping-address/address-renderer/default.js.
         *
         * @returns {mixin}
         */
        initialize: function () {
            this._super();
            self = this;

            this.editVisible = ko.observable(false); // for "New address"
            this.selectedShipAddress = ko.observable();

            let shippingAddress = quote.shippingAddress();
            if (shippingAddress) {
                this.hasDefaultShippingAddress = true;
            }

            // set shipping address on change dropdown
            self.selectedShipAddress.subscribe(function (value) {
                let shippingAddessDropdown = $("select.shipping-address-items");
                if (value !== undefined) {
                    if (self.hasDefaultShippingAddress) {
                        self.hasDefaultShippingAddress = false;
                    } else {
                        let isEditAble = value.address().isEditable();
                        shippingAddessDropdown.removeClass('editable-address');
                        if(isEditAble) {
                            shippingAddessDropdown.addClass('editable-address');
                        }
                        self.editVisible(isEditAble);
                        value.selectAddress();
                    }
                } else {
                    self.editVisible(false);
                }
            });

            // select default address
            this.selectedAddressItem = ko.computed(function () {
                let currentIndex = 0;
                if (self.selectedShipAddress() !== undefined) {
                    currentIndex = self.selectedShipAddress().index;
                }

                this.elems().forEach(function (element) {
                    if (element.isSelected() && currentIndex != element.index) {
                        self.selectedShipAddress(element);
                    }
                });
            }, this);
            this.selectedAddressItem.extend({rateLimit: 50}); // knockout fix

            return this;
        },

        /**
         * for "New address" option
         */
        editAddress: function () {
            this.selectedShipAddress().editAddress();
        },
    };

    return function (Component) {
        return Component.extend(mixin);
    }
});
